import QtQuick 2.0
import "../MedComponents"
Item {
    id: root
    signal requestBack()
    Rectangle {
        anchors.fill: parent
        color: "lightgrey"

        Text {
            id: timeZoneLabel
            anchors.left: parent.left
            anchors.top: parent.top
            anchors.margins: parent.height *0.03
            text: "Time Offset from UTC"
            font.pixelSize: parent.height * 0.08
        }

        SpinBox {
            id: timeZoneSelector
            anchors.top: timeZoneLabel.top
            anchors.left: timeZoneLabel.right
            anchors.leftMargin: 6
            currentValue: dateTime.utcOffset
            onCurrentValueChanged: dateTime.utcOffset = currentValue
        }

        Text {
            id: screenSaverLabel
            anchors.left: parent.left
            anchors.top: timeZoneLabel.bottom
            anchors.margins: parent.height *0.03
            text: "Screen timeout (seconds)"
            font.pixelSize: parent.height * 0.08
        }

        SpinBox {
            id: screenSaverSelector
            anchors.top: screenSaverLabel.top
            anchors.left: screenSaverLabel.right
            anchors.leftMargin: 6
            currentValue: dateTime.screenSaverTimeout
            onCurrentValueChanged: dateTime.screenSaverTimeout = currentValue
        }

        Button {
            anchors.bottom: parent.bottom
            anchors.left: parent.left
            anchors.right: parent.right
            height: parent.height * 0.1
            text: "Back to List"
            onClicked: root.requestBack()
        }
    }
}
